/* 
 * fscanf-fprintf.c 
 *
 * Обчислює середні бали студентів згідно
 * заданого журналу успішності.
 * Ілюструє порядок застосування функцій fopen(), fscanf(), fprintf().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


int main(int argc, char *argv[])
{
        FILE *in;

        if (argc < 2)
                /* Читати буде стандартний потік введення. */
                in = stdin;
        else {
                /* Читати буде файл. */
                in = fopen(argv[1], "r");
                if (in == NULL) {
                        fprintf(stderr, "Error opening input stream: %s\n",
                                                        strerror(errno));
                        exit(EXIT_FAILURE);
                }
        }

        while (1) {
                char surname[21];
                char init1[3];
                char init2[3];
                unsigned int val1, val2, val3, val4;

                if (fscanf(in, "%20s %2s %2s %u %u %u %u", surname,
                        init1, init2, &val1, &val2, &val3, &val4) == EOF) {
                        if (ferror(in)) {
                                fprintf(stderr, "Error reading from"
                                                " input stream: %s\n",
                                                        strerror(errno));
                                exit(EXIT_FAILURE);
                        }
                        exit(EXIT_SUCCESS);
                }
                fprintf(stdout, "%s %s %s\t%.2f\n",
                                surname, init1, init2,
                                (float) (val1 + val2 + val3 + val4) / 4);
        } 
}
